// (c) Michael Schoeffler 2014, http://www.mschoeffler.de original demo code
#include "SPI.h" // SPI library
#include "MFRC522.h" // RFID library (https://github.com/miguelbalboa/rfid)
const int pinRST = A0;
const int pinSDA = A2;

unsigned long previousMillis = 0;        // will store last time LED was updated
const long interval = 5000;           // interval at which to blink (milliseconds)

uint64_t serialNumber64 = 0x00ULL;
uint64_t oldSerialNumber64 = 0x00ULL;

String uint64ToStringMax(uint64_t input, int maxLen) 
{
  String result = "";
  uint8_t base = 10;

  do 
  {
    char c = input % base;
    input /= base;

    if (c < 10)
      c +='0';
    else
      c += 'A' - 10;
    result = c + result;
  } while (input);
  result="00000000"+result;

  int resLen = result.length();
  if (resLen>maxLen)
  {
    result = result.substring(resLen-maxLen,resLen);
  }
  
  return result;
}

MFRC522 mfrc522(pinSDA, pinRST); // Set up mfrc522 on the Arduino
void setup() 
{
  pinMode(13, OUTPUT);

  SPI.begin(); // open SPI connection
  mfrc522.PCD_Init(); // Initialize Proximity Coupling Device (PCD)
  Serial.begin(9600); // open serial connection
  for (int i=0; i<3; i++)
  {
    Serial.println("Boot...");
    delay(500);
    digitalWrite(13, HIGH);
    delay(500);
    digitalWrite(13, LOW);

  }

}
void loop() 
{
  unsigned long currentMillis = millis();
 
  if (currentMillis - previousMillis >= interval) 
  {
    // save the last time you blinked the LED
    previousMillis = currentMillis;
    Serial.print("Tick...");
    Serial.println(millis());
  }
  
  if (mfrc522.PICC_IsNewCardPresent()) 
  { // (true, if RFID tag/card is present ) PICC = Proximity Integrated Circuit Card
    Serial.println("INFO: Card Present");
    if(mfrc522.PICC_ReadCardSerial()) 
    { // true, if RFID tag/card was read
      Serial.print("HexUID: ");

      serialNumber64 = 0x00ULL;
      
      
      for (byte i = 0; i < mfrc522.uid.size; ++i) 
      { // read id (in parts)
        //Serial.print(mfrc522.uid.uidByte[mfrc522.uid.size - 1 - i], HEX); // print id as hex values big endian
        Serial.print(mfrc522.uid.uidByte[i], HEX); // print id as hex values litle endian
        serialNumber64 = serialNumber64 +(uint64_t)((uint64_t)mfrc522.uid.uidByte[i] <<  (i * 8));
        //Serial.print(" "); // add space between hex blocks to increase readability
      }
      Serial.println("");
      
      Serial.print("DecUID: ");
      if ( mfrc522.uid.size < 5 )
      {
        Serial.println(uint64ToStringMax(serialNumber64,10));
      }
      else
      {
        Serial.println(uint64ToStringMax(serialNumber64,17));
      }

      
      //Serial.println(); // Print out of id is complete.
      for (int i=0; i<10; i++)
      {
          digitalWrite(13, HIGH);
          delay(100);  // Dont bother reading again for another 5 seconds
          digitalWrite(13,LOW);
          delay(100);
      }
      
    }
  }
}
